<?php namespace App\Controllers\Api\Customer\Projects\Builds;

use App\Controllers\PrivateController;
use App\Models\AppsModel;
use App\Models\BuildsModel;
use App\Models\SubscribesModel;
use App\Models\PlansModel;
use CodeIgniter\HTTP\ResponseInterface;

class BuildsList extends PrivateController
{
    /**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Get builds versions
     * @return ResponseInterface
     */
    public function index(): ResponseInterface
    {
        $uid = esc($this->request->getGet("uid"));

        $projects = new AppsModel();

        $app = $projects
            ->where("uid", $uid)
            ->where("user", $this->userId)
            ->where("deleted_at", 0)
            ->select("id")
            ->first();

        if (!$app) {
            return $this->respond(["message" => lang("Message.message_14")], 404);
        }
      
      	$subscribes = new SubscribesModel();
      
      	// Lấy thông tin đăng ký hiện tại của ứng dụng
        $subscribe = $subscribes
            ->where("app_id", $app["id"])
            ->where("expires_at >", time())
            ->where("is_disable", 0)
            ->select("expires_at, plan_id, remaining_count, id") // Thêm plan_id và remaining_count
            ->first();

        $builds = new BuildsModel();

        $items = $builds
            ->where("app_id", $app["id"])
            ->orderBy("id", "DESC")
            ->findAll();

        $list = [];
        foreach ($items as $build) {
            $list[] = [
                "uid"      => $build["uid"],
                "platform" => $build["platform"],
                "status"   => (int) $build["status"],
                "version"  => $build["version"],
                "publish"  => (int) $build["publish"],
                "created"  => date('d-m-Y H:i', $build['created_at']),
                "format"   => $build["platform"] == "ios" ? "ipa" : $build["format"],
                "fail"     => (bool) $build["fail"],
                "message"  => $build["message"]
            ];
        }
      
      	// Khởi tạo giá trị mặc định cho remaining_count và build_count
        $remaining_count = 0;
        $build_count = 0;

		// Khai báo và khởi tạo PlansModel
        $plans = new PlansModel();
      
      	// Kiểm tra và lấy thông tin về số lượt build còn lại và tổng số lượt build
        if ($subscribe && isset($subscribe['plan_id'])) {
            $plan = $plans->find($subscribe['plan_id']);
            if ($plan) {
                $remaining_count = $subscribe['remaining_count'] ?? 0;
                $build_count = $plan['build_count'] ?? 0;

                // Cập nhật remaining_count nếu bằng 0 và build_count > 0
                if ($remaining_count == 0 && $build_count > 0) {
                    $remaining_count = $build_count;
                    $subscribes->update($subscribe['id'], ['remaining_count' => $remaining_count]);

                    // Ghi log
                    log_message('info', "Đã cập nhật remaining_count cho subscribe ID {$subscribe['id']}: $remaining_count");
                }
            }
        }

        return $this->respond(["list" => $list, "remaining_count" => $remaining_count, "build_count" => $build_count], 200);
    }

}